local assets =
{ 
    Asset("ANIM", "anim/gibus.zip"),
    Asset("ANIM", "anim/gibus_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/gibus.xml"),
    Asset("IMAGE", "images/inventoryimages/gibus.tex"),
}

local prefabs = 
{
}

local function OnEquip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_hat", "gibus_swap", "swap_hat")	
	
		owner.AnimState:Show("HAT")
		owner.AnimState:Show("HAT_HAIR")
		owner.AnimState:Hide("HAIR_NOHAT")
		owner.AnimState:Hide("HAIR")
		
		if owner:HasTag("player") then
			owner.AnimState:Hide("HEAD")
			owner.AnimState:Show("HEAD_HAIR")
		end
	
    if inst.components.fueled then
	inst.components.fueled:StartConsuming()
    end
end
	
local function OnUnequip(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_hat")
		owner.AnimState:Hide("HAT")
		owner.AnimState:Hide("HAT_HAIR")
		owner.AnimState:Show("HAIR_NOHAT")
		owner.AnimState:Show("HAIR")

		if owner:HasTag("player") then
			owner.AnimState:Show("HEAD")
			owner.AnimState:Hide("HEAD_HAIR")
		end
	
    if inst.components.fueled then
	inst.components.fueled:StopConsuming()
    end
end
	
local function fn()

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("gibus")
    inst.AnimState:SetBuild("gibus")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("hat")

    inst:AddComponent("fueled")
    inst.components.fueled.fueltype = "USAGE"
    inst.components.fueled:InitializeFuelLevel(TUNING.EARMUFF_PERISHTIME)
    inst.components.fueled:SetDepletedFn(inst.Remove)
	
    inst:AddComponent("inspectable")
    inst:AddComponent("tradable")

    inst:AddComponent("dapperness")
    inst.components.dapperness.dapperness = TUNING.DAPPERNESS_SMALL

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "gibus"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/gibus.xml"

    return inst
end

return  Prefab("common/inventory/gibus", fn, assets, prefabs)